<?php
/**
 * GS Team - Layout Category Filter
 * @author GS Plugins <hello@gsplugins.com>
 * 
 * This template can be overridden by copying it to yourtheme/gs-team/partials/gs-team-layout-cat-filters.php
 * 
 * @package GS_Team/Templates
 * @version 1.0.0
 */

do_action( 'gs_team_before_cats_filters' );

$cats = gs_team_get_terms( 'team_group', 'ASC', 'name', gs_team_excluded_term_ids( $exclude_group ) );

// Remove extra items fomr $cats array if group is specified
if ( ! empty($group) ) {
    $selected_cats = explode( ',' , $group );
    foreach ( $cats as $key => $val ) {
        if ( ! in_array($key, $selected_cats) ) unset( $cats[$key] );
    }
}

?>

<ul class="gs-team-filter-cats" style="text-align: <?php echo $gs_tm_filter_cat_pos; ?>">

    <?php if ( $gs_filter_all_enabled == 'on' ) : ?>
        <li class="filter" data-filter="*"><?php echo $fitler_all_text; ?></li>
    <?php endif; ?>

    <?php foreach ( $cats as $slug => $name ) : ?>
        <li class="filter" data-filter=".<?php echo $slug; ?>"><?php echo $name; ?></li>
    <?php endforeach; ?>

</ul>