<?php

/*
 * Config file with each demo data
 */

$sparklestore = array(
    'default' => array(
        'name' => 'Sparkle Store - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/default/default.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/default/default.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/sparklestore/free-sparklestore/',
        'menuArray' => array(
            'sparkleprimary' => 'Main Menu',
            'sparklecategory' => 'Category',
            'sparkletopmenu' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'elementor' => array(
        'name' => 'Sparkle Store - Elementor',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/elementor/elementor.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/elementor/elementor.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/sparklestore/el-sparklestore/',
        'menuArray' => array(
            'sparkleprimary' => 'Main Menu',
            'sparklecategory' => 'Category',
            'sparkletopmenu' => 'Top Menu'
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),

        ),
        'home_slug' => 'elementor-home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce',
            'cosmetics' => 'Cosmetics',
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        )
    ),
    'cosmetics' => array(
        'name' => 'Cosmetics Store',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/cosmetics/cosmetics.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/cosmetics/cosmetics.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/sparklestore/cosmetics/',
        'menuArray' => array(
            'sparkleprimary' => 'Main Menu',
            'sparklecategory' => 'Category',
            'sparkletopmenu' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'jewellery' => array(
        'name' => 'RTL Demo ( jewellery )',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/jewellery/jewellery.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/sparklestore/jewellery/jewellery.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/sparklestore/jewellery/',
        'menuArray' => array(
            'sparkleprimary' => 'Main Menu',
            'sparklecategory' => 'Categories',
            'sparkletopmenu' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
            'rtl'      => 'RTL'
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    )
); // tested

$crazystore = $sparklestore; // tested


$educenter = array(
    'demo-one' => array(
        'name' => 'Educenter',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/educenter/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/educenter/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/educenter',
        'menuArray' => array(
            'menu-1' => 'Menu 1',
            'menu-2' => 'Menu 2',
        ),
        'home_slug' => 'home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'education' => 'Education'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        )
    ),
    'demo-two' => array(
        'name' => 'Educenter',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/educenter/demo-two/demo-two.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/educenter/demo-two/demo-two.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/educenter',
        'menuArray' => array(
            'menu-1' => 'Menu 1',
            'menu-2' => 'Menu 2',
        ),
        'home_slug' => 'home',
        'blog_slug' => 'blog',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'education' => 'Education'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        )
    )
); // tested

$construction_light = array(
    'demo-one' => array(
        'name' => 'Construction Light - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'construction' => 'construction'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'demo-two' => array(
        'name' => 'Construction Light',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/demo-two/demo-two.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/demo-two/demo-two.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/sample-v1/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'construction' => 'Construction'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'box-layout' => array(
        'name' => 'Box Layout',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/box-layout/box-layout.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/box-layout/box-layout.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/sample-v2/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'construction' => 'Construction'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'agency' => array(
        'name' => 'Agency',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/agency/agency.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/agency/agency.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/agency/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'gutentor' => "Gutentor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            ),
            'gutentor' => array(
                'name' => 'Gutentor',
                'file_path' => 'gutentor/gutentor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'education' => array(
        'name' => 'Education',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/education/education.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/education/education.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/education/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'education' => 'Education'
        ),/*Categories*/
        'pagebuilder' => array(
            'gutentor' => "Gutentor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            ),
            'gutentor' => array(
                'name' => 'Gutentor',
                'file_path' => 'gutentor/gutentor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'charity' => array(
        'name' => 'Charity',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/charity/charity.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/charity/charity.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/charity/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'charity' => 'charity'
        ),/*Categories*/
        'pagebuilder' => array(
            'gutentor' => "Gutentor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            ),
            'gutentor' => array(
                'name' => 'Gutentor',
                'file_path' => 'gutentor/gutentor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'lawyer' => array(
        'name' => 'Lawyer',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/lawyer/lawyer.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/lawyer/lawyer.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/lawyer/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'lawyer' => 'Lawyer'
        ),/*Categories*/
        'pagebuilder' => array(
            'gutentor' => "Gutentor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            ),
            'gutentor' => array(
                'name' => 'Gutentor',
                'file_path' => 'gutentor/gutentor.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'restaurant' => array(
        'name' => 'Restaurant',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/restaurant/restaurant.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/constructionlight/restaurant/restaurant.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/constructionlight/restaurant/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'restaurant' => 'Restaurant'
        ),/*Categories*/
        'pagebuilder' => array(
            'gutentor' => "Gutentor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'file_path' => 'elementor/elementor.php',
                'source' => 'wordpress',
            ),
            'gutentor' => array(
                'name' => 'Gutentor',
                'file_path' => 'gutentor/gutentor.php',
                'source' => 'wordpress',
            )

        ),
    ),
);// tested

$craft_blog = array(
    'demo-one' => array(
        'name' => 'Craft Blog - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/craftblog/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/craftblog/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/craftblog/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'Home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'craftblog' => 'Craft Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
           

        ),
    ),
    
    'demo-two' => array(
        'name' => 'Craft Blog - Pro',
        'image' => 'https://demo.sparklewpthemes.com/craftblogpro/demos/wp-content/uploads/sites/14/2020/12/1-4.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/craftblogpro/technology/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'Home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'craftblog' => 'Craft Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/craftblogpro/'
    ),
    'demo-three' => array(
        'name' => 'Craft Blog - Pro',
        'image' => 'https://demo.sparklewpthemes.com/craftblogpro/demos/wp-content/uploads/sites/14/2020/12/1-7.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/craftblogpro/sample-v4/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'Home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'craftblog' => 'Craft Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/craftblogpro/'
    ),
); // tested

$blogger_buzz = array(
    'demo-one' => array(
        'name' => 'Blogger Buzz - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/bloggerbuzz/',
        'menuArray' => array(
            'menu-1' => 'Main Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'demo-two' => array(
        'name' => 'Blogger Buzz',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-two/demo-two.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-two/demo-two.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/bloggerbuzz/sample-v1/',
        'menuArray' => array(
            'menu-1' => 'Main Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'demo-three' => array(
        'name' => 'Blogger Buzz',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-three/demo-three.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/bloggerbuzz/demo-three/demo-three.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/bloggerbuzz/sample-v2/',
        'menuArray' => array(
            'menu-1' => 'Main Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
); // tested

$buzzstore = array(
    'medical' => array(
        'name' => 'Buzzstore - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/medical/medical.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/medical/medical.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/buzzstore/',
        'menuArray' => array(
            'primary' => 'Main Menu',
            'topmenu' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'jewellery' => array(
        'name' => 'Jewellery',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/jewellery/jewellery.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/jewellery/jewellery.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/buzzstore/jewellery/',
        'menuArray' => array(
            'primary' => 'Main Menu',
            'topmenu' => 'Top Menu'
        ),
        
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
    'technology' => array(
        'name' => 'Technology',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/technology/technology.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/buzzstore/technology/technology.jpg',
        'preview_url' => 'https://demo.sparklewpthemes.com/buzzstore/technology/',
        'menuArray' => array(
            'primary' => 'Main Menu',
            'topmenu' => 'Top Menu'
        ),
        
        'home_slug' => 'home',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'woocommerce' => 'WooCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )

        ),
    ),
); // tested


$editorialmag = array(
    'editorialmag' => array(
        'name' => 'Editorailmag - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/editorialmag/editorialmag.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/editorialmag/editorialmag.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'craftblog' => 'Craft Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )
    ),
    'glamour' => array(
        'name' => 'Glamour',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/glamour/glamour.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/glamour/glamour.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/glamour',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'glamour' => 'Glamour'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )
    ),
    'sport' => array(
        'name' => 'Sport',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/sport/sport.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/sport/sport.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/sport/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'sport' => 'sport'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )
    ),
    'tech' => array(
        'name' => 'Tech',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/tech/tech.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/tech/tech.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/tech/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'tech' => 'tech'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )
    ),

    'pro1' => array(
        'name' => 'Editorial Mag - Pro',
        'image' => 'https://demo.sparklewpthemes.com/editorialmagpro/demos/wp-content/uploads/sites/6/2020/12/pro-tech.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmagpro/tech/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro'     => 'Premium',
        ),
        'categories' => array( 
            'tech' => 'tech'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/editorialmagpro/'
        
    ),
    'pro2' => array(
        'name' => 'Editorial Mag - Pro',
        'image' => 'https://demo.sparklewpthemes.com/editorialmagpro/demos/wp-content/uploads/sites/6/2020/12/free-sport.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/sport/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro'     => 'Premium',
        ),
        'categories' => array( 
            'tech' => 'tech'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/editorialmagpro/'
        
    ),
);//tested

$editorialmag_lite = array(
    'demo-one' => array(
        'name' => 'Editorailmag Lite - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/editorialmaglite/editorialmaglite/editorialmaglite.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/editorialmag/editorialmag/editorialmag.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/editorialmag/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => ' ',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'editorialmaglite' => 'Editorailmag Lite'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )
    ),
);//tested

$fitness_park = array(
    'demo-one' => array(
        'name' => 'Fitness Park - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/fitnesspark/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/fitnesspark/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/fitnesspark/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'footer-menu' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        ) 
    ),

    'demo-two' => array(
        'name' => 'Fitness Park - Pro',
        'image' => 'https://demo.sparklewpthemes.com/fitnessparkpro/demos/wp-content/uploads/sites/7/2020/12/4.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/fitnessparkpro/demo01/home02/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'footer-menu' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Pro',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/premium-wordpress-fitness-theme/'
        
    ),
    'demo-three' => array(
        'name' => 'Fitness Park - Pro',
        'image' => 'https://demo.sparklewpthemes.com/fitnessparkpro/demos/wp-content/uploads/sites/7/2020/12/2.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/fitnessparkpro/demo02/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'footer-menu' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Pro',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/premium-wordpress-fitness-theme/'
    ),
);// not tested

$kathmag = array(
    'kathmag' => array(
        'name' => 'Kathmag - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/kathmag/kathmag.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/kathmag/kathmag.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/kathmag/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),
    'technology' => array(
        'name' => 'Technology',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/technology/technology.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/technology/technology.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/kathmag/technology/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'free'     => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),
    'sport' => array(
        'name' => 'Sport',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/sport/sport.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/sport/sport.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/kathmag/sport/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),
    'fashion' => array(
        'name' => 'Fashion',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/fashion/fashion.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/kathmag/fashion/fashion.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/kathmag/fashion/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),

    'pro-1' => array(
        'name' => 'Kathmag Pro',
        'image' => 'https://sparklewpthemes.com/wp-content/uploads/2018/05/Kathmag-Pro-Magazine.png',
        'preview_url' => 'http://demo.sparklewpthemes.com/kathmagpro/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro' => 'Pemium',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/kathmagpro/'
    ),
    'pro-2' => array(
        'name' => 'Kathmag Pro - Technology',
        'image' => 'https://sparklewpthemes.com/wp-content/uploads/2018/05/Kathmag-Pro-Technology.png',
        'preview_url' => 'http://demo.sparklewpthemes.com/kathmagpro/tech/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Footer'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro' => 'Pemium',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/kathmagpro/'
    ),
);// not tested

$kingcabs = array(
    'demo-one' => array(
        'name' => 'Kingcabs - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/kingcabs/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/kingcabs/demo-one/demo-one.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/kingcabs/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),   
);//not tested

$medical_heed = array(
    'demo-one' => array(
        'name' => 'Medical Heed - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/medicalheed/demo-one/demo-one.zip',
        'image' => 'https://demo.sparklewpthemes.com/medicalheedpro/demos/wp-content/uploads/sites/4/2020/12/2.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/medicalheed/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'medical' => 'Medical'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),
    
    'demo-two' => array(
        'name' => 'Medical Heed - Pro',
        'image' => 'https://demo.sparklewpthemes.com/medicalheedpro/demos/wp-content/uploads/sites/4/2020/12/1.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/medicalheedpro/demo02/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'medical' => 'Medical'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/medicalheedpro/'
    ),

    'demo-three' => array(
        'name' => 'Medical Heed - Pro',
        'image' => 'https://demo.sparklewpthemes.com/medicalheedpro/demos/wp-content/uploads/sites/4/2020/12/4.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/medicalheedpro/sample-v2/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'medical' => 'Medical'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/medicalheedpro/'
    ),
);//tested

$metrostore = array(
    'metrostore' => array(
        'name' => 'Metro Store - Main',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/metrostore/metrostore/metrostore.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/metrostore/metrostore/metrostore.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/metrostore/',
        'menuArray' => array(
            'primary' => 'Primary'
        ),
        'home_slug' => 'front-page',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'store' => 'Store'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),
    'corporate-business' => array(
        'name' => 'Corporate Business',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/metrostore/corporate-business/corporate-business.zip',
        'image' => 'https://sparklewpthemes.com/wp-content/uploads/2017/05/MetroStore-Corporate.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/metrostore/corporate',
        'menuArray' => array(
            'primary' => 'Primary'
        ),
        'home_slug' => 'front-page',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'store' => 'Store'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),  
    'pro-1' => array(
        'name' => 'Watch',
        'image' => 'https://sparklewpthemes.com/wp-content/uploads/2017/05/MetroStore-watch.png',
        'preview_url' => 'http://demo.sparklewpthemes.com/metrostore/watches/',
        'menuArray' => array(
            'primary' => 'Primary'
        ),
        'home_slug' => 'front-page',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'store' => 'Store'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/metrostorepro/'  
    ),  
    'pro-2' => array(
        'name' => 'Pharmacy',
        'image' => 'https://sparklewpthemes.com/wp-content/uploads/2017/05/MetroStore-Pharmecy.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/metrostore/pharmacy/',
        'menuArray' => array(
            'primary' => 'Primary'
        ),
        'home_slug' => 'front-page',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'store' => 'Store'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/metrostorepro/'  
    ),   
);//tested

$ocelot = array(
    'ocelotblog' => array(
        'name' => 'Ocelot Blog',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/ocelotblog/ocelotblog.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/ocelotblog/ocelotblog.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/ocelot/',
        'menuArray' => array(
            'menu-1' => 'Primary',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => ' ',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),   
);//tested

$royal_blog = array(
    'royalblog' => array(
        'name' => 'Royal Blog',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/royalblog/royalblog/royalblog.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/royalblog/royalblog/royalblog.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/royalblog/',
        'menuArray' => array(
            'menu-1' => 'Primary',
            'menu-2' => 'Top Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),   
);//tested


$online_estore = array(
    'online-estore' => array(
        'name' => 'Main Demo 1',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/online-estore.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/online-estore.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore/',
        'menuArray' => array(
            'menu-1' => 'Main Menu',
            'menu-2' => 'Top Menu',
            'menu-3' => 'Product Category',
            'menu-4' => 'Footer Menu',

        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ), 
    'pro-1' => array(
        'name' => 'Construction - Pro',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/construction.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore-pro/construction',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce',
            'construction' => 'Construction'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/online-estore-pro/'
    ), 
    
    'pro-2' => array(
        'name' => 'Shoe Shop - Pro',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/shoeshop.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore-pro/shoeshop',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/online-estore-pro/'
    ), 
    
    'pro-3' => array(
        'name' => 'Fashion - Pro',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/fashion.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore-pro/fashion',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/online-estore-pro/'
    ), 
    
    'pro-4' => array(
        'name' => 'Foodic - Pro',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/foodic.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore-pro/foodic',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/online-estore-pro/'
    ), 
    'pro-5' => array(
        'name' => 'Technology - Pro',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/online-estore/technology.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/online-estore-pro/technology',
        'tags' => array(
            'pro' => 'Premium',
        ),
        'categories' => array( 
            'eommerce' => 'eCommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/online-estore-pro/'
    ), 
);//tested


$spidermag = array(
    'spidermag' => array(
        'name' => 'Spider Mag',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/spidermag/spidermag.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/spidermag/spidermag.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/spidermag/',
        'menuArray' => array(
            'primary' => 'Primary',
            'top' => 'Top Menu',
            'footer' => 'Footer'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ), 
    'glamour' => array(
        'name' => 'Glamour',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/glamour/glamour.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/glamour/glamour.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/spidermag/glamour',
        'menuArray' => array(
            'primary' => 'Primary',
            'top' => 'Top Menu',
            'footer' => 'Footer'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'blog' => 'Blog'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ), 
    'sport' => array(
        'name' => 'Sport',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/sport/sport.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/sport/sport.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/spidermag/sport',
        'menuArray' => array(
            'primary' => 'Primary',
            'top' => 'Top Menu',
            'footer' => 'Footer'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'sport' => 'Sport'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ), 
    'tech' => array(
        'name' => 'Tech',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/tech/tech.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/spidermag/tech/tech.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/spidermag/tech',
        'menuArray' => array(
            'primary' => 'Primary',
            'top' => 'Top Menu',
            'footer' => 'Footer'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'technology' => 'Technology'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            )
        )   
    ),  
);//not tested


$appzend = array(
    'v1' => array(
        'name' => 'AppZend V1',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/appzend/v1/v1.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/appzend/v1/v1.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/v1/',
        'menuArray' => array(
            'menu-1' => 'Primary Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            )
        )   
    ),

    'organic' => array(
        'name' => 'Organic',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/appzend/organic/organic.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/appzend/organic/organic.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/organic/',
        'menuArray' => array(
            'menu-1' => 'main-menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'ecommerce' => 'Ecommerce'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'woocommerce' => array(
                'name' => 'WooCommerce',
                'source' => 'wordpress',
                'file_path' => 'woocommerce/woocommerce.php',
            ),
            'yith-woocommerce-compare' => array(
                'name' => 'YITH WooCommerce Compare',
                'source' => 'wordpress',
                'file_path' => 'yith-woocommerce-compare/init.php',
            ),
            'yith-woocommerce-quick-view' => array(
                'name' => 'YITH WooCommerce Quick View',
                'file_path' => 'yith-woocommerce-quick-view/init.php',
                'source' => 'wordpress',
            ),
            'yith-woocommerce-wishlist' => array(
                'name' => 'YITH WooCommerce Wishlist',
                'file_path' => 'yith-woocommerce-wishlist/init.php',
                'source' => 'wordpress',
            ),
        )   
    ),
    
    'redapple' => array(
        'name' => 'Red Apple',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/appzend/redapple/redapple.zip',
        'image'        => 'https://demo.sparklewpthemes.com/demo-data/appzend/redapple/redapple.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/redapple/',
        'menuArray' => array(
            'menu-1' => 'Primary Menu'
        ),
        'home_slug' => '',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            )
        )   
    ),
    
    'coachung-online-zym-training' => array(
        'name' => 'AppZend ZYM - Elementor',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/coachung-online-zym-training/coachung-online-zym-training.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/coachung-online-zym-training/coachung-online-zym-training.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/coachung-online-zym-training/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ), 
    
    'digital-agency' => array(
        'name' => 'AppZend Digal Agency',
        'external_url' => 'https://demo.sparklewpthemes.com/demo-data/appzend/digital-agency/digital-agency.zip',
        'image' => 'https://demo.sparklewpthemes.com/demo-data/appzend/digital-agency/digital-agency.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/digital-agency/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ), 

    'spa' => array(
        'name' => 'AppZend - SPA',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/spa/spa.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/spa/spa.png',
        'preview_url'   => 'https://demo.sparklewpthemes.com/appzend/spa/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ),
    

    'spa-salon' => array(
        'name' => 'SPA Salon',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/spa-salon/spa-salon.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/spa-salon/spa-salon.png',
        'preview_url'   => 'https://demo.sparklewpthemes.com/appzend/spa-salon/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ),
    
    'agency-1' => array(
        'name' => 'Agency 1',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/agency-1/agency-1.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/agency-1/agency-1.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/agency-1/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ),
    

    'agency-2' => array(
        'name' => 'Agency 1',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/agency-2/agency-2.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/agency-2/agency-2.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/agency-2/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ),
    
    'auto-dealer' => array(
        'name' => 'Agency 1',
        'external_url'  => 'https://demo.sparklewpthemes.com/demo-data/appzend/auto-dealer/auto-dealer.zip',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/auto-dealer/auto-dealer.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/auto-dealer/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'free' => 'Free',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
            'contact-form-7' => array(
                'name' => 'Contact Form 7',
                'source' => 'wordpress',
                'file_path' => 'contact-form-7/wp-contact-form-7.php'
            ),
            'elementor' => array(
                'name' => 'Elementor',
                'source' => 'wordpress',
                'file_path' => 'elementor/elementor.php',
            ),
            'sina-extension-for-elementor' => array(
                'name' => 'Sina Extension',
                'source' => 'wordpress',
                'file_path' => 'sina-extension-for-elementor/sina-extension-for-elementor.php',
            ),
            'premium-addons-for-elementor' => array(
                'name' => 'Premium Addons for Elementor',
                'source' => 'wordpress',
                'file_path' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
            ),
            'elementskit-lite' => array(
                'name' => 'Elements kit Elementor addons',
                'source' => 'wordpress',
                'file_path' => 'elementskit-lite/elementskit-lite.php',
            ),
        )   
    ),

    'zendconstruction' => array(
        'name' => 'Construction - Elementor',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/pro/zendconstruction/zendconstruction.png',
        'preview_url'   => 'https://demo.sparklewpthemes.com/appzend/zendconstruction/',
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/appzend/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => 'home',
        'tags' => array(
            'premium' => 'Premium',
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'elementor' => "Elementor",
        ),
        'plugins' => array(
        )   
    ),
    'education' => array(
        'name' => 'Education',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/pro/education/education.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/education/',
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/appzend/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => '',
        'tags' => array(
            'premium' => 'Premium',
            'agency' => 'Agency'
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        )
    ),
    'wine' => array(
        'name' => 'Wine',
        'image'         => 'https://demo.sparklewpthemes.com/demo-data/appzend/pro/wine/wine.png',
        'preview_url' => 'https://demo.sparklewpthemes.com/appzend/wine/',
        'type' => 'pro',
        'buy_url' => 'https://sparklewpthemes.com/wordpress-themes/appzend/',
        'menuArray' => array(
            'menu-1' => 'Menu 1'
        ),
        'home_slug' => '',
        'tags' => array(
            'premium' => 'Premium',
            'agency' => 'Agency'
        ),
        'categories' => array( 
            'agency' => 'Agency'
        ),/*Categories*/
        'pagebuilder' => array(
            'widget' => "Widgets",
        )
    ),
    
); // tested

$active_theme = str_replace('-', '_', get_option('stylesheet'));

if (isset($$active_theme)) {
    $demo_array = $$active_theme;
} else {
    $demo_array = array();
}

return apply_filters('sparkle_demo_import_config', $demo_array);